
#ifndef CRYS_HOST_TST_HASH
#define CRYS_HOST_TST_HASH

/***************************************************************** 
*  @file CRYS_HOST_TST_HASH.c
*  @brief Functions used for HOST-SEP communication to send message from HOST to SEP
*         that contains requested API to be executed in SEP and API parameters
*         Used for SEP External application ATP testing.
*
*  @author mottig
*  @remarks Copyright (C) 2004 by Discretix Technologies Ltd.
*           All Rights reserved
*/

/************************ Includes *****************************/
#include "DX_VOS_BaseTypes.h"
#include "ExtApp_CRYS_Defines.h"
#include "CRYS.h"

#ifdef __cplusplus
extern "C"
{
#endif


/************************ Defines ******************************/



/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/************************Public Variables **********************/

/*********************** Public Functions **********************/

/***********************************************************************
* Function Name:                                                           
*  SEPQA_HASH_NotIntegrated         
* 
* Inputs:
* Inputs:
* OperationMode - The operation mode for hash
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes HASH not integrated test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_HASH_NotIntegrated(CRYS_HASH_OperationMode_t   OperationMode,
        								   DxUint8_t                  *DataIn_ptr,
        								   DxUint32_t                  DataInSize,
        								   DxUint8_t                  *ExpectedData_ptr,        
        								   DxUint32_t                  DataExpSize,
        								   char                       *FailureFunctionNameOut_ptr,
        								   DxUint32_t                  FuncNameMaxSize);
        								   
/***********************************************************************
* Function Name:                                                           
*  SEPQA_HASH_Integrated         
* 
* Inputs:
* Inputs:
* OperationMode - The operation mode for hash
* DataIn_ptr - a pointer to the buffer that stores the data to be 
*                       hashed . 
* DataInSize - The size of the data to be hashed in bytes. 
* ExpectedData_ptr - The pointer to the expected data of the AES operation. 
*                   The pointer's value does not need to be word-aligned.
* DataExpSize - The size of the expected data
* OutputLocation - indication if input buffer == output buffer or not.
* FailureFunctionNameOut_ptr - In case that function failures this parameter
*                                             returns the name of the function that failures
* FuncNameMaxSize - The allocated size of the FailureFunctionNameOut_ptr
*
* Outputs:
*  CRYSError_t - Function error return                                     
*
* Description:
*  This function is used to operate the qa external application on the SEP, 
*  that executes HASH integrated test
* Algorithm:       
* 1. initiate and start the message 
* 2. prepare message with all non buffer parameters of the API
* 3. send all buffers params                                   
* 4. end message
* 5. wait for the response of SEP side
* 6. start reading message from the SEP  and check returned function status from SEP
*
**************************************************************************/                                
EXPORT_C DxUint32 SEPQA_HASH_Integrated(CRYS_HASH_OperationMode_t   OperationMode,
        								   DxUint8_t                  *DataIn_ptr,
        								   DxUint32_t                  DataInSize,
        								   DxUint8_t                  *ExpectedData_ptr,        
        								   DxUint32_t                  DataExpSize,
        								   char                       *FailureFunctionNameOut_ptr,
        								   DxUint32_t                  FuncNameMaxSize);
        								   
									  

#ifdef __cplusplus
}
#endif

#endif  /* CRYS_HOST_TST_HASH */
